<?php
// Callback function to render the block
function render_asasi_server_block($attributes) {
    global $wpdb;

    // Get the server number from the block attributes
    $server_number = isset($attributes['server']) ? intval($attributes['server']) : 0;

    $html = ''; // Variable to store the generated HTML

    // Query to get server information
    $server = $wpdb->get_results("SELECT 
                s.ServerNumber, 
                s.ServerName, 
                IF(s.ClusterNumber = 0, '" . __('No cluster', 'asa-server-info') . "', c.ClusterName) AS ClusterName, 
                s.ServerBMid 
                FROM {$wpdb->prefix}asa_servers AS s 
                LEFT JOIN {$wpdb->prefix}asa_clusters AS c 
                ON s.ClusterNumber = c.ClusterNumber 
                WHERE ServerNumber = {$server_number}"
            );

    // Check if the server was found
    if ($server) {
        $server = $server[0]; // Access the first element of the result array

        // Get additional server data from the Battlemetrics API
        $battlemetrics_url = "https://api.battlemetrics.com/servers/{$server->ServerBMid}";
        $battlemetrics_response = wp_remote_get($battlemetrics_url);

        // Check if the API request was successful
        if (!is_wp_error($battlemetrics_response) && wp_remote_retrieve_response_code($battlemetrics_response) === 200) {
            $battlemetrics_data = json_decode(wp_remote_retrieve_body($battlemetrics_response));

            // Build the HTML for the server page
            $html .= '<div class="Container">';
            $html .= '<div class="ServerInfo">';
            $html .= '<div class="ServerInfoHead"><h4>' . esc_html__('General Information', 'asa-server-info') . '</h4></div>';
            $html .= '<div class="ServerInfoBody">';
            $html .= '<p>' . esc_html__('Current Name:', 'asa-server-info') . ' ' . $battlemetrics_data->data->attributes->name . '<br>';
			if (is_null($battlemetrics_data->data->attributes->address)) {
				$address = $battlemetrics_data->data->attributes->ip;
			}else{
				$address = $battlemetrics_data->data->attributes->address;
			}
            $html .= esc_html__('Address:', 'asa-server-info') . ' ' . $address . ':' . $battlemetrics_data->data->attributes->port . '<br>';
            $html .= esc_html__('Connect Command:', 'asa-server-info') . ' <b>open ' . $address . ':' . $battlemetrics_data->data->attributes->port . '</b><br>';
            if ($battlemetrics_data->data->attributes->status == "online") {
                $html .= esc_html__('Status:', 'asa-server-info') . ' <span style="color:#008800;">' . esc_html__('Online', 'asa-server-info') . '</span><br>';
            }else{
                $html .= esc_html__('Status:', 'asa-server-info') . ' <span style="color:#FF0000;">' . esc_html__('Offline', 'asa-server-info') . '</span><br>';
            }
			$html .= esc_html__('Cluster:', 'asa-server-info') . ' ' . $server->ClusterName . '<br>';
            $html .= esc_html__('Players Online:', 'asa-server-info') . ' ' . $battlemetrics_data->data->attributes->players . '/' . $battlemetrics_data->data->attributes->maxPlayers . '<br>';
            if ($battlemetrics_data->data->attributes->details->pve) {
                $html .= esc_html__('Mode:', 'asa-server-info') . ' PvE<br>';
            }else{
                $html .= esc_html__('Mode:', 'asa-server-info') . ' PvP<br>';
            }
            $html .= esc_html__('Map:', 'asa-server-info') . ' ' . $battlemetrics_data->data->attributes->details->map . '<br>';
            $html .= esc_html__('Day:', 'asa-server-info') . ' ' . $battlemetrics_data->data->attributes->details->time_i . '<br>';
            $html .= esc_html__('BattleMetrics Rank:', 'asa-server-info') . ' <a href="https://www.battlemetrics.com/servers/arksa/' . $server->ServerBMid . '" target="_blank">' . $battlemetrics_data->data->attributes->rank . '</a><br>';

            // Add more content here as needed...
            $html .= '</p>';
            $html .= '</div>';
            $html .= '</div>';
			
			if (!empty($battlemetrics_data->data->attributes->details->modLinks)) {
				$html .= '<div class="ServerInfo">';
				$html .= '<div class="ServerInfoHead"><h4>' . esc_html__('Mods', 'asa-server-info') . '</h4></div>';
				$html .= '<div class="ServerInfoBody">';
				$html .= '<ul>';
				// Iterate over the arrays to generate the link list
				for ($i = 0; $i < count($battlemetrics_data->data->attributes->details->modLinks); $i++) {
					$html .= '<li><a href="' . $battlemetrics_data->data->attributes->details->modLinks[$i] . '" target="_blank">' . $battlemetrics_data->data->attributes->details->modNames[$i] . '</a></li>';
				}
				$html .= '</ul>';
				$html .= '</div>';
				$html .= '</div>';
			} else {
				echo esc_html__('No mods found', 'asa-server-info');
			}
			$html .= '</div>';
        } else {
            // Show error message if API request failed
            $html .= '<p>' . esc_html__('Error retrieving server data from Battlemetrics API.', 'asa-server-info') . '</p>';
        }
    } else {
        // Show error message if server not found
        $html .= '<p>' . esc_html__('Server not found.', 'asa-server-info') . '</p>';
    }

    return $html; // Return the generated HTML
}

// Register the custom block
function register_asasi_server_block() {
    // Define block attributes
    $block_attributes = array(
        'server' => array(
            'type' => 'number', // Attribute type: number
        ),
    );

    // Register the block in WordPress using register_block_type_from_metadata()
    register_block_type_from_metadata(
        __DIR__ . '/asa-server',
        array(
            'render_callback' => 'render_asasi_server_block', // Callback function to render the block
        )
    );
}
add_action('init', 'register_asasi_server_block');

?>